/*
 * Decompiled with CFR 0.152.
 */
package com.yurtmod.structure;

import com.yurtmod.block.Categories;
import com.yurtmod.dimension.TentDimension;
import com.yurtmod.structure.Blueprints;
import com.yurtmod.structure.StructureBase;
import com.yurtmod.structure.StructureType;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class StructureBedouin
extends StructureBase {
    private static final Blueprints BP_SMALL = StructureBedouin.makeBlueprints(StructureType.Size.SMALL, new Blueprints());
    private static final Blueprints BP_MED = StructureBedouin.makeBlueprints(StructureType.Size.MEDIUM, new Blueprints());
    private static final Blueprints BP_LARGE = StructureBedouin.makeBlueprints(StructureType.Size.LARGE, new Blueprints());

    public StructureBedouin(StructureType type) {
        super(type);
    }

    @Override
    public boolean generate(World worldIn, BlockPos doorBase, EnumFacing dirForward, StructureType.Size size, Block doorBlock, Block wallBlock, Block roofBlock) {
        boolean tentDim = TentDimension.isTentDimension(worldIn);
        switch (size) {
            case LARGE: {
                this.buildLayer(worldIn, doorBase, dirForward, wallBlock, BP_LARGE.getWallCoords());
                this.buildLayer(worldIn, doorBase, dirForward, roofBlock, BP_LARGE.getRoofCoords());
                StructureBedouin.buildDoor(worldIn, doorBase, doorBlock, dirForward);
                if (tentDim) {
                    BlockPos pos = StructureBedouin.getPosFromDoor(doorBase, 4, -1, 0, TentDimension.STRUCTURE_DIR);
                    worldIn.func_180501_a(pos, Blocks.field_150424_aL.func_176223_P(), 2);
                    worldIn.func_180501_a(pos.func_177984_a(), Blocks.field_150480_ab.func_176223_P(), 2);
                }
                return true;
            }
            case MEDIUM: {
                this.buildLayer(worldIn, doorBase, dirForward, wallBlock, BP_MED.getWallCoords());
                this.buildLayer(worldIn, doorBase, dirForward, roofBlock, BP_MED.getRoofCoords());
                StructureBedouin.buildDoor(worldIn, doorBase, doorBlock, dirForward);
                if (tentDim) {
                    BlockPos pos = StructureBedouin.getPosFromDoor(doorBase, 3, -1, 0, TentDimension.STRUCTURE_DIR);
                    worldIn.func_180501_a(pos, Blocks.field_150424_aL.func_176223_P(), 2);
                    worldIn.func_180501_a(pos.func_177984_a(), Blocks.field_150480_ab.func_176223_P(), 2);
                }
                return true;
            }
            case SMALL: {
                this.buildLayer(worldIn, doorBase, dirForward, wallBlock, BP_SMALL.getWallCoords());
                this.buildLayer(worldIn, doorBase, dirForward, roofBlock, BP_SMALL.getRoofCoords());
                StructureBedouin.buildDoor(worldIn, doorBase, doorBlock, dirForward);
                if (tentDim) {
                    BlockPos pos = StructureBedouin.getPosFromDoor(doorBase, 2, -1, 0, TentDimension.STRUCTURE_DIR);
                    worldIn.func_180501_a(pos, Blocks.field_150346_d.func_176223_P(), 2);
                    worldIn.func_180501_a(pos.func_177981_b(1), Blocks.field_150478_aa.func_176223_P(), 2);
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean canSpawn(World worldIn, BlockPos doorBase, EnumFacing facing, StructureType.Size size) {
        Blueprints bp;
        Blueprints blueprints = size.equals((Object)StructureType.Size.SMALL) ? BP_SMALL : (size.equals((Object)StructureType.Size.MEDIUM) ? BP_MED : (bp = size.equals((Object)StructureType.Size.LARGE) ? BP_LARGE : null));
        if (!StructureBedouin.validateArray(worldIn, doorBase, bp.getWallCoords(), facing, REPLACE_BLOCK_PRED)) {
            return false;
        }
        return StructureBedouin.validateArray(worldIn, doorBase, bp.getRoofCoords(), facing, REPLACE_BLOCK_PRED);
    }

    @Override
    public boolean isValidForFacing(World worldIn, BlockPos doorBase, StructureType.Size size, EnumFacing facing) {
        Blueprints bp;
        Predicate<IBlockState> checkBlockPred = new Predicate<IBlockState>(){

            @Override
            public boolean test(IBlockState b) {
                return b.func_177230_c() instanceof Categories.IBedouinBlock;
            }
        };
        Blueprints blueprints = size.equals((Object)StructureType.Size.SMALL) ? BP_SMALL : (size.equals((Object)StructureType.Size.MEDIUM) ? BP_MED : (bp = size.equals((Object)StructureType.Size.LARGE) ? BP_LARGE : null));
        if (!StructureBedouin.validateArray(worldIn, doorBase, bp.getWallCoords(), facing, checkBlockPred)) {
            return false;
        }
        return StructureBedouin.validateArray(worldIn, doorBase, bp.getRoofCoords(), facing, checkBlockPred);
    }

    public static Blueprints makeBlueprints(StructureType.Size size, Blueprints bp) {
        switch (size) {
            case SMALL: {
                bp.addWallCoords(new int[][]{{0, 0, 1}, {0, 0, 0}, {0, 0, -1}, {1, 0, -2}, {2, 0, -2}, {3, 0, -2}, {4, 0, -1}, {4, 0, 0}, {4, 0, 1}, {3, 0, 2}, {2, 0, 2}, {1, 0, 2}, {0, 1, 1}, {0, 1, 0}, {0, 1, -1}, {1, 1, -2}, {2, 1, -2}, {3, 1, -2}, {4, 1, -1}, {4, 1, 0}, {4, 1, 1}, {3, 1, 2}, {2, 1, 2}, {1, 1, 2}});
                bp.addRoofCoords(new int[][]{{0, 2, 0}, {1, 2, 1}, {2, 2, 1}, {3, 2, 1}, {4, 2, 0}, {1, 2, -1}, {2, 2, -1}, {3, 2, -1}, {1, 3, 0}, {2, 3, 0}, {3, 3, 0}});
                break;
            }
            case MEDIUM: {
                bp.addWallCoords(new int[][]{{0, 0, -2}, {0, 0, -1}, {0, 0, 0}, {0, 0, 1}, {0, 0, 2}, {1, 0, 3}, {2, 0, 3}, {3, 0, 3}, {4, 0, 3}, {5, 0, 3}, {6, 0, -2}, {6, 0, -1}, {6, 0, 0}, {6, 0, 1}, {6, 0, 2}, {1, 0, -3}, {2, 0, -3}, {3, 0, -3}, {4, 0, -3}, {5, 0, -3}, {0, 1, -2}, {0, 1, -1}, {0, 1, 0}, {0, 1, 1}, {0, 1, 2}, {1, 1, 3}, {2, 1, 3}, {3, 1, 3}, {4, 1, 3}, {5, 1, 3}, {6, 1, -2}, {6, 1, -1}, {6, 1, 0}, {6, 1, 1}, {6, 1, 2}, {1, 1, -3}, {2, 1, -3}, {3, 1, -3}, {4, 1, -3}, {5, 1, -3}});
                bp.addRoofCoords(new int[][]{{0, 2, -1}, {0, 2, 0}, {0, 2, 1}, {1, 2, 2}, {2, 2, 2}, {3, 2, 2}, {4, 2, 2}, {5, 2, 2}, {6, 2, -1}, {6, 2, 0}, {6, 2, 1}, {1, 2, -2}, {2, 2, -2}, {3, 2, -2}, {4, 2, -2}, {5, 2, -2}, {0, 3, 0}, {1, 3, 1}, {2, 3, 1}, {3, 3, 1}, {4, 3, 1}, {5, 3, 1}, {6, 3, 0}, {1, 3, -1}, {2, 3, -1}, {3, 3, -1}, {4, 3, -1}, {5, 3, -1}, {1, 4, 0}, {2, 4, 0}, {3, 4, 0}, {4, 4, 0}, {5, 4, 0}});
                break;
            }
            case LARGE: {
                bp.addWallCoords(new int[][]{{0, 0, -3}, {0, 0, -2}, {0, 0, -1}, {0, 0, 0}, {0, 0, 1}, {0, 0, 2}, {0, 0, 3}, {1, 0, 4}, {2, 0, 4}, {3, 0, 4}, {4, 0, 4}, {5, 0, 4}, {6, 0, 4}, {7, 0, 4}, {8, 0, -3}, {8, 0, -2}, {8, 0, -1}, {8, 0, 0}, {8, 0, 1}, {8, 0, 2}, {8, 0, 3}, {1, 0, -4}, {2, 0, -4}, {3, 0, -4}, {4, 0, -4}, {5, 0, -4}, {6, 0, -4}, {7, 0, -4}, {0, 1, -3}, {0, 1, -2}, {0, 1, -1}, {0, 1, 0}, {0, 1, 1}, {0, 1, 2}, {0, 1, 3}, {1, 1, 4}, {2, 1, 4}, {3, 1, 4}, {4, 1, 4}, {5, 1, 4}, {6, 1, 4}, {7, 1, 4}, {8, 1, -3}, {8, 1, -2}, {8, 1, -1}, {8, 1, 0}, {8, 1, 1}, {8, 1, 2}, {8, 1, 3}, {1, 1, -4}, {2, 1, -4}, {3, 1, -4}, {4, 1, -4}, {5, 1, -4}, {6, 1, -4}, {7, 1, -4}});
                bp.addRoofCoords(new int[][]{{0, 2, -2}, {0, 2, -1}, {0, 2, 0}, {0, 2, 1}, {0, 2, 2}, {1, 2, 3}, {2, 2, 3}, {3, 2, 3}, {4, 2, 3}, {5, 2, 3}, {6, 2, 3}, {7, 2, 3}, {8, 2, -2}, {8, 2, -1}, {8, 2, 0}, {8, 2, 1}, {8, 2, 2}, {1, 2, -3}, {2, 2, -3}, {3, 2, -3}, {4, 2, -3}, {5, 2, -3}, {6, 2, -3}, {7, 2, -3}, {0, 3, -1}, {0, 3, 0}, {0, 3, 1}, {8, 3, -1}, {8, 3, 0}, {8, 3, 1}, {1, 3, 2}, {2, 3, 2}, {3, 3, 2}, {4, 3, 2}, {5, 3, 2}, {6, 3, 2}, {7, 3, 2}, {1, 3, -2}, {2, 3, -2}, {3, 3, -2}, {4, 3, -2}, {5, 3, -2}, {6, 3, -2}, {7, 3, -2}, {0, 4, 0}, {8, 4, 0}, {1, 4, 1}, {2, 4, 1}, {3, 4, 1}, {4, 4, 1}, {5, 4, 1}, {6, 4, 1}, {7, 4, 1}, {1, 4, -1}, {2, 4, -1}, {3, 4, -1}, {4, 4, -1}, {5, 4, -1}, {6, 4, -1}, {7, 4, -1}, {1, 5, 0}, {2, 5, 0}, {3, 5, 0}, {4, 5, 0}, {5, 5, 0}, {6, 5, 0}, {7, 5, 0}});
            }
        }
        return bp;
    }
}

